-- Tabele z pliku AgencjaArtystycznaStruktura.sql muszą zostać utworzone najpierw.

USE AgencjaArtystycznaPrzyklad;
GO

CREATE VIEW R04_lista_telefonow_agentow
AS
SELECT TOP (100) PERCENT  NazwiskoAgenta, ImieAgenta, TelefonAgenta
FROM         Agenci
ORDER BY NazwiskoAgenta, ImieAgenta;
GO

CREATE VIEW R04_daty_imprez
AS
SELECT DISTINCT DzienRozpoczecia
FROM Imprezy ;
GO

CREATE VIEW R04_informacje_o_imprezach
AS
SELECT Imprezy.*
FROM Imprezy ;
GO

CREATE VIEW R04_siedziby_wykonawcow
AS
SELECT TOP (100) PERCENT MiastoWykonawcy, NazwaScenicznaWykonawcy
FROM         Wykonawcy
ORDER BY MiastoWykonawcy, NazwaScenicznaWykonawcy;
GO

CREATE VIEW R04_zaplanowane_imprezy
AS
SELECT  TOP (100) PERCENT DzienRozpoczecia, NumerImprezy
FROM         Imprezy
ORDER BY DzienRozpoczecia DESC, NumerImprezy;
GO

CREATE VIEW R05_klienci_wedlug_miasta
AS
SELECT TOP (100) PERCENT MiastoKlienta AS Miasto, NazwiskoKlienta + ', ' + ImieKlienta AS Klient
FROM         Klienci
ORDER BY Miasto, Klient;
GO

CREATE VIEW R05_dlugosc_imprez
AS
SELECT     NumerImprezy, CAST(DateDiff(d, DzienRozpoczecia, DzienZakonczenia) + 1 AS varchar) + ' dni (dzień)' AS CzasTrwania
FROM         Imprezy;
GO

CREATE VIEW R05_strony_www_wykonawcow
AS
SELECT NazwaScenicznaWykonawcy AS Wykonawca, 'Strona WWW: ' + StronaInterWykonawcy AS Odwiedz
FROM Wykonawcy ;
GO

CREATE VIEW R05_pierwszy_sprawdzian_polroczny
AS
SELECT TOP (100) PERCENT NazwiskoAgenta + ', ' + ImieAgenta AS Agent, DataZatrudnienia, DateAdd(d, 180, DataZatrudnienia) AS PierwszySprawdzian
FROM         Agenci
ORDER BY Agent;
GO

CREATE VIEW R05_wartosc_netto_kontraktow
AS
SELECT NumerImprezy, WartoscKontraktu, WartoscKontraktu * 0.12 AS NaszeHonorarium, WartoscKontraktu - (WartoscKontraktu * 0.12) AS WartoscNetto
FROM Imprezy ;
GO

CREATE VIEW R06_wykonawcy_z_trzech_miast
AS
SELECT  TOP (100) PERCENT NazwaScenicznaWykonawcy, TelefonWykonawcy, MiastoWykonawcy
FROM         Wykonawcy
WHERE      MiastoWykonawcy IN ('Bellevue', 'Redmond', 'Woodinville')
ORDER BY NazwaScenicznaWykonawcy;
GO

CREATE VIEW R06_czterodniowe_imprezy
AS
SELECT NumerImprezy, DzienRozpoczecia, DzienZakonczenia
FROM Imprezy
WHERE DateDiff(d, DzienRozpoczecia, DzienZakonczenia)=3 ;

GO

CREATE VIEW R06_imprezy_w_pazdzierniku_2017
AS
SELECT NumerImprezy, WartoscKontraktu, DzienRozpoczecia, DzienZakonczenia
FROM Imprezy
WHERE DzienRozpoczecia <= '10/31/2017' AND DzienZakonczenia >= '10/1/2017' ;
GO

CREATE VIEW R06_imprezy_pazdziernikowe_miedzy_12_a_17
AS
SELECT     NumerImprezy, DzienRozpoczecia, GodzinaRozpoczecia
FROM         Imprezy
WHERE     (DzienRozpoczecia <= '10/31/2017') AND (DzienZakonczenia >= '10/1/2017') 
AND (GodzinaRozpoczecia BETWEEN '12:00:00 PM' AND '5:00:00 PM');
GO

CREATE VIEW R06_imprezy_jednodniowe
AS
SELECT NumerImprezy, DzienRozpoczecia, DzienZakonczenia
FROM Imprezy
WHERE DzienRozpoczecia = DzienZakonczenia ;
GO

CREATE VIEW R08_agenci_i_daty_imprez
AS
SELECT  TOP (100) PERCENT Agenci.ImieAgenta + ' ' + Agenci.NazwiskoAgenta AS PersonaliaAgenta, Imprezy.DzienRozpoczecia
FROM         Agenci 
INNER JOIN   Imprezy 
ON Agenci.IDAgenta = Imprezy.IDAgenta
ORDER BY Imprezy.DzienRozpoczecia;
GO

CREATE VIEW R08_agenci_i_wykonawcy_ten_sam_kod_pocztowy
AS
SELECT (Agenci.ImieAgenta + ' ' + Agenci.NazwiskoAgenta) AS PersonaliaAgenta, Wykonawcy.NazwaScenicznaWykonawcy, Agenci.KodPocztowyAgenta
FROM         Agenci 
INNER JOIN   Wykonawcy 
ON (Agenci.KodPocztowyAgenta = Wykonawcy.KodPocztowyWykonawcy) ;
GO

CREATE VIEW R08_klienci_i_zamowione_przez_nich_wystepy
AS
SELECT DISTINCT (Klienci.ImieKlienta + ' ' + Klienci.NazwiskoKlienta) AS PersonaliaKlienta, Wykonawcy.NazwaScenicznaWykonawcy
FROM (Klienci 
INNER JOIN Imprezy 
ON (Klienci.IDKlienta = Imprezy.IDKlienta)) 
INNER JOIN Wykonawcy 
ON (Wykonawcy.IDWykonawcy = Imprezy.IDWykonawcy) ;
GO

CREATE VIEW R08_wykonawcy_i_kontrakty
AS
SELECT Wykonawcy.NazwaScenicznaWykonawcy, Imprezy.DzienRozpoczecia, Imprezy.DzienZakonczenia, Imprezy.WartoscKontraktu
FROM         Wykonawcy 
INNER JOIN   Imprezy 
ON (Wykonawcy.IDWykonawcy = Imprezy.IDWykonawcy) ;
GO

CREATE VIEW R08_wykonawcy_wystepujacy_dla_Berga_I_Hallmark
AS
SELECT     EntBerg.NazwaScenicznaWykonawcy
FROM 
        (SELECT DISTINCT Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
             FROM          (Wykonawcy 
             INNER JOIN     Imprezy 
             ON Wykonawcy.IDWykonawcy = Imprezy.IDWykonawcy) 
             INNER JOIN     Klienci 
             ON Klienci.IDKlienta = Imprezy.IDKlienta
             WHERE      Klienci.NazwiskoKlienta = 'Berg') AS EntBerg 
         INNER JOIN
        (SELECT DISTINCT Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
             FROM          (Wykonawcy 
             INNER JOIN     Imprezy 
             ON Wykonawcy.IDWykonawcy = Imprezy.IDWykonawcy) 
             INNER JOIN     Klienci 
             ON Klienci.IDKlienta = Imprezy.IDKlienta
             WHERE      Klienci.NazwiskoKlienta = 'Hallmark') AS EntHallmark 
         ON EntBerg.IDWykonawcy = EntHallmark.IDWykonawcy;
GO

CREATE VIEW R08_wykonawcy_wystepujacy_dla_Berga_LUB_Hallmark
AS
SELECT DISTINCT Wykonawcy.NazwaScenicznaWykonawcy
FROM (Wykonawcy 
INNER JOIN Imprezy 
ON (Wykonawcy.IDWykonawcy = Imprezy.IDWykonawcy)) 
INNER JOIN Klienci 
ON (Klienci.IDKlienta = Imprezy.IDKlienta)
WHERE Klienci.NazwiskoKlienta = 'Berg' 
OR Klienci.NazwiskoKlienta = 'Hallmark' ;
GO

CREATE VIEW R09_agenci_bez_kontraktow
AS
SELECT Agenci.IDAgenta, Agenci.ImieAgenta, Agenci.NazwiskoAgenta
FROM Agenci LEFT JOIN Imprezy 
ON (Agenci.IDAgenta = Imprezy.IDAgenta)
WHERE Imprezy.NumerImprezy IS NULL ;
GO

CREATE VIEW R09_wszyscy_wykonawcy_dowolne_imprezy
AS
SELECT Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy, Imprezy.NumerImprezy, Imprezy.DzienRozpoczecia, Imprezy.IDKlienta
FROM Wykonawcy LEFT JOIN Imprezy 
ON (Wykonawcy.IDWykonawcy = Imprezy.IDWykonawcy) ;
GO

CREATE VIEW R09_wszystkie_style_i_dowolni_klienci
AS
SELECT Style_muzyczne.IDStylu, Style_muzyczne.NazwaStylu, Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM Style_muzyczne LEFT JOIN (Gusty_muzyczne
INNER JOIN Klienci
ON Klienci.IDKlienta = Gusty_muzyczne.IDKlienta)
ON Style_muzyczne.IDStylu = Gusty_muzyczne.IDStylu;
GO

CREATE VIEW R09_klienci_brak_rezerwacji
AS
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM Klienci LEFT JOIN Imprezy 
ON (Klienci.IDKlienta = Imprezy.IDKlienta)
WHERE Imprezy.NumerImprezy IS NULL ;
GO

CREATE VIEW R09_wykonawcy_nigdy_nie_zamawiani
AS
SELECT Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
FROM Wykonawcy LEFT JOIN Imprezy 
ON (Wykonawcy.IDWykonawcy = Imprezy.IDWykonawcy)
WHERE Imprezy.NumerImprezy Is Null ;
GO

CREATE VIEW R10_agenci_UNION_wykonawcy
AS
SELECT     Agenci.NazwiskoAgenta + ', ' + Agenci.ImieAgenta AS Personalia, 'Agent' AS Typ
FROM         Agenci
UNION
SELECT     Wykonawcy.NazwaScenicznaWykonawcy, 'Wykonawca' AS Typ
FROM         Wykonawcy;
GO

CREATE VIEW R10_klienci_i_wykonawcy_muzyka_wspolczesna
AS
SELECT     Klienci.ImieKlienta + ' ' + Klienci.NazwiskoKlienta AS Personalia, 'Klient' AS Typ
FROM         Style_muzyczne 
INNER JOIN   (Klienci 
INNER JOIN    Gusty_muzyczne 
ON (Klienci.IDKlienta = Gusty_muzyczne.IDKlienta)) 
ON (Style_muzyczne.IDStylu = Gusty_muzyczne.IDStylu)
WHERE     Style_muzyczne.NazwaStylu = 'Współczesna'
UNION
SELECT     Wykonawcy.NazwaScenicznaWykonawcy, 'Wykonawca' AS Typ
FROM         Style_muzyczne 
INNER JOIN   (Wykonawcy 
INNER JOIN    Style_wykonawcow 
ON (Wykonawcy.IDWykonawcy = Style_wykonawcow.IDWykonawcy)) 
ON (Style_muzyczne.IDStylu = Style_wykonawcow.IDStylu)
WHERE     Style_muzyczne.NazwaStylu = 'Współczesna';
GO

CREATE VIEW R10_klienci_UNION_wykonawcy
AS
SELECT     Klienci.NazwiskoKlienta + ', ' + Klienci.ImieKlienta AS Personalia, 'Klient' AS Typ
FROM         Klienci
UNION
SELECT     Wykonawcy.NazwaScenicznaWykonawcy AS Personalia, 'Wykonawca' AS Typ
FROM         Wykonawcy;
GO

CREATE VIEW R11_nieoperatywni_agenci
AS 
SELECT Agenci.IDAgenta, Agenci.ImieAgenta, Agenci.NazwiskoAgenta
FROM Agenci
WHERE Agenci.IDAgenta NOT IN 
(SELECT Imprezy.IDAgenta
 FROM Imprezy);
 GO
 
CREATE VIEW R11_ostatnia_rezerwacja_klientow
AS
SELECT Klienci.ImieKlienta, Klienci.NazwiskoKlienta, (Select max(DzienRozpoczecia) FROM Imprezy WHERE Imprezy.IDKlienta = Klienci.IDKlienta) AS OstatniaRezerwacja
FROM Klienci ;
GO

CREATE VIEW R11_klienci_ktorzy_lubia_muzyke_country
AS
SELECT     IDKlienta, ImieKlienta, NazwiskoKlienta
FROM         Klienci
WHERE     (IDKlienta IN
          (SELECT     Imprezy.IDKlienta
           FROM     ((Style_muzyczne 
           INNER JOIN Style_wykonawcow 
           ON Style_muzyczne.IDStylu = Style_wykonawcow.IDStylu) 
           INNER JOIN Wykonawcy 
           ON Wykonawcy.IDWykonawcy = Style_wykonawcow.IDWykonawcy) 
           INNER JOIN Imprezy 
           ON Wykonawcy.IDWykonawcy = Imprezy.IDWykonawcy
           WHERE      Style_muzyczne.NazwaStylu = 'Country' OR
                      Style_muzyczne.NazwaStylu = 'Country Rock'));
GO

CREATE VIEW R11_liczba_wystepow_wykonawcow
AS
SELECT Wykonawcy.NazwaScenicznaWykonawcy, (SELECT count(*) FROM Imprezy WHERE Imprezy.IDWykonawcy = Wykonawcy.IDWykonawcy) AS LiczbaWystepow
FROM Wykonawcy ;
GO

CREATE VIEW R11_wykonawcy_dla_klienta_Berg_EXISTS
AS 
SELECT     Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
FROM         Wykonawcy
WHERE     EXISTS 
          (SELECT * 
           FROM        Klienci 
           INNER JOIN  Imprezy 
           ON Klienci.IDKlienta = Imprezy.IDKlienta 
           WHERE Klienci.NazwiskoKlienta='Berg'
              AND Imprezy.IDWykonawcy = Wykonawcy.IDWykonawcy);
GO

CREATE VIEW R11_wykonawcy_dla_klienta_Berg_IN
AS 
SELECT     Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
FROM         Wykonawcy
WHERE      IDWykonawcy IN 
           (SELECT    Imprezy.IDWykonawcy 
            FROM       Klienci 
            INNER JOIN Imprezy 
            ON Klienci.IDKlienta = Imprezy.IDKlienta 
            WHERE Klienci.NazwiskoKlienta='Berg');
GO


CREATE VIEW R11_wykonawcy_dla_klientow_Berg_lub_Hallmark_SOME
AS
SELECT     IDWykonawcy, NazwaScenicznaWykonawcy
FROM         Wykonawcy
WHERE     (IDWykonawcy = SOME
            (SELECT     Imprezy.IDWykonawcy
             FROM          Klienci 
             INNER JOIN    Imprezy 
             ON Klienci.IDKlienta = Imprezy.IDKlienta
             WHERE      Klienci.NazwiskoKlienta = 'Berg' 
              OR       Klienci.NazwiskoKlienta = 'Hallmark'));
GO

CREATE VIEW R12_srednia_placa_agenta
AS
SELECT avg(Wynagrodzenie) AS SredniaPlacaAgenta
FROM Agenci ;
GO

CREATE VIEW R12_wartosc_kontraktu_wieksza_od_sredniej
AS
SELECT     NumerImprezy
FROM         Imprezy
WHERE     (WartoscKontraktu >=
                          (SELECT     AVG(WartoscKontraktu)
                            FROM          Imprezy));
GO

CREATE VIEW R12_najstarsze_imprezy
AS
SELECT NumerImprezy, WartoscKontraktu
FROM Imprezy
WHERE DzienRozpoczecia =    
    (SELECT min(DzienRozpoczecia) FROM Imprezy) ;
GO

CREATE VIEW R12_najstarsze_imprezy_w_pazdzierniku
AS
SELECT Imprezy.NumerImprezy, Imprezy.DzienRozpoczecia, Imprezy.DzienZakonczenia, Imprezy.IDKlienta
FROM Imprezy
WHERE Imprezy.DzienRozpoczecia = 
   (SELECT MIN(DzienRozpoczecia) FROM Imprezy WHERE DzienRozpoczecia BETWEEN '2017-10-01' AND '2017-10-31');
GO

CREATE VIEW R12_imprezy_drozsze_niz_suma_wrzesnia
AS
SELECT NumerImprezy, WartoscKontraktu
FROM Imprezy
WHERE WartoscKontraktu >
   (SELECT SUM(WartoscKontraktu) FROM Imprezy
     WHERE DzienRozpoczecia BETWEEN '2017-09-01'
     AND '2017-09-30');
GO

CREATE VIEW R12_liczba_wykonawcow_mieszkajacych_w_Bellevue
AS
SELECT count(*) AS LiczbaWykonawcow
FROM Wykonawcy
WHERE MiastoWykonawcy = 'Bellevue' ;
GO

CREATE VIEW R12_laczna_wartosc_kontraktow_w_pazdzierniku_2017
AS
SELECT sum(WartoscKontraktu) AS TotalBookedValue
FROM Imprezy
WHERE DzienRozpoczecia BETWEEN '10/1/2017' AND '10/31/2017' ;
GO

CREATE VIEW R13_sumy_kontraktow_i_prowizje_agentow
AS
SELECT Agenci.ImieAgenta, Agenci.NazwiskoAgenta, sum(Imprezy.WartoscKontraktu) AS SumaWartosciKontraktow, convert(money,sum(WartoscKontraktu) * Premia) AS Prowizja
FROM Agenci 
INNER JOIN Imprezy 
ON (Agenci.IDAgenta = Imprezy.IDAgenta)
GROUP BY Agenci.ImieAgenta, Agenci.NazwiskoAgenta, Agenci.Premia ;
GO

CREATE VIEW R13_zestawienie_informacji_o_kontraktach_wszyscy_wykonawcy
AS
SELECT Wykonawcy.NazwaScenicznaWykonawcy, Count(Imprezy.IDWykonawcy) AS LiczbaKontraktow, 
Sum(Imprezy.WartoscKontraktu) AS WartOgolem, Min(Imprezy.WartoscKontraktu) AS CenaMin, 
Max(Imprezy.WartoscKontraktu) AS CenaMaks, Avg(Imprezy.WartoscKontraktu) AS CenaSrd
FROM Wykonawcy 
LEFT JOIN Imprezy 
ON Wykonawcy.IDWykonawcy=Imprezy.IDWykonawcy
GROUP BY Wykonawcy.NazwaScenicznaWykonawcy;
GO

CREATE VIEW R13_zestawienie_informacji_o_kontraktach_wszyscy_wykonawcy_ZLE
AS
SELECT Wykonawcy.NazwaScenicznaWykonawcy, Count(*) AS LiczbaKontraktow, 
Sum(Imprezy.WartoscKontraktu) AS WartOgolem, Min(Imprezy.WartoscKontraktu) AS CenaMin, 
Max(Imprezy.WartoscKontraktu) AS CenaMaks, Avg(Imprezy.WartoscKontraktu) AS CenaSrd
FROM Wykonawcy 
LEFT JOIN Imprezy 
ON Wykonawcy.IDWykonawcy=Imprezy.IDWykonawcy
GROUP BY Wykonawcy.NazwaScenicznaWykonawcy;
GO

CREATE VIEW R13_zestawienie_informacji_o_kontraktach_wg_klienta
AS
SELECT Klienci.NazwiskoKlienta, Klienci.ImieKlienta, count(*) AS LiczbaKontraktow, 
sum(Imprezy.WartoscKontraktu) AS WartOgolem, min(Imprezy.WartoscKontraktu) AS CenaMin, 
max(Imprezy.WartoscKontraktu) AS CenaMaks, avg(Imprezy.WartoscKontraktu) AS CenaSrd
FROM Klienci 
INNER JOIN Imprezy 
ON (Klienci.IDKlienta = Imprezy.IDKlienta)
GROUP BY Klienci.NazwiskoKlienta, Klienci.ImieKlienta ;
GO

CREATE VIEW R13_zestawienie_informacji_o_kontraktach_wg_wykonawcy
AS
SELECT Wykonawcy.NazwaScenicznaWykonawcy, count(*) AS LiczbaKontraktow, sum(Imprezy.WartoscKontraktu) AS WartOgolem, min(Imprezy.WartoscKontraktu) AS CenaMin, max(Imprezy.WartoscKontraktu) AS CenaMaks, avg(Imprezy.WartoscKontraktu) AS CenaSrd
FROM Wykonawcy 
INNER JOIN Imprezy 
ON (Wykonawcy.IDWykonawcy = Imprezy.IDWykonawcy)
GROUP BY Wykonawcy.NazwaScenicznaWykonawcy ;
GO

CREATE VIEW R13_kontrakt_stulecia
AS
SELECT     Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Imprezy.DzienRozpoczecia, Imprezy.WartoscKontraktu
FROM       Klienci 
           INNER JOIN Imprezy 
           ON Klienci.IDKlienta = Imprezy.IDKlienta
WHERE     (Imprezy.WartoscKontraktu > ALL
                 (SELECT     SUM(WartoscKontraktu)
                   FROM          Imprezy AS E2
                   WHERE      E2.IDKlienta <> Klienci.IDKlienta
                   GROUP BY E2.IDKlienta));
GO

CREATE VIEW R13_najnowsze_kontrakty_klientow
AS
SELECT Klienci.NazwiskoKlienta + ', ' + Klienci.ImieKlienta AS PersonaliaKlienta, Klienci.AdresKlienta + ', ' + Klienci.MiastoKlienta + ', ' + Klienci.StanZamKlienta + ' ' + Klienci.KodPocztowyKlienta AS PelnyAdresKlienta, max(Imprezy.DzienRozpoczecia) AS OstatniaData, sum(Imprezy.WartoscKontraktu) AS LacznaWartoscKontraktu
FROM Klienci 
INNER JOIN Imprezy 
ON (Klienci.IDKlienta = Imprezy.IDKlienta)
GROUP BY Klienci.NazwiskoKlienta, Klienci.ImieKlienta, Klienci.AdresKlienta, Klienci.MiastoKlienta, Klienci.StanZamKlienta, Klienci.KodPocztowyKlienta ;
GO

CREATE VIEW R13_laczna_wartosc_kontraktow
AS
SELECT CE.PersonaliaKlienta,
   CE.PelnyAdresKlienta,
   MAX(CE.DzienRozpoczecia) AS OstatniaData,
   SUM(CE.WartoscKontraktu) AS LacznaWartoscKontraktu
FROM
    (SELECT Klienci.NazwiskoKlienta + ', ' +
   Klienci.ImieKlienta AS PersonaliaKlienta,
      Klienci.AdresKlienta + ', ' +
      Klienci.MiastoKlienta + ', ' +
      Klienci.StanZamKlienta + ' ' +
      Klienci.KodPocztowyKlienta AS PelnyAdresKlienta,
      Imprezy.DzienRozpoczecia,
      Imprezy.WartoscKontraktu
   FROM Klienci
   INNER JOIN Imprezy
   ON Klienci.IDKlienta =
      Imprezy.IDKlienta
   WHERE Klienci.StanZamKlienta ='WA')
AS CE
GROUP BY CE.PersonaliaKlienta,
   CE.PelnyAdresKlienta;
GO

CREATE VIEW R13_wykonawcy_i_wartosci_kontraktow
AS
SELECT TOP (100) PERCENT Wykonawcy.NazwaScenicznaWykonawcy, Imprezy.WartoscKontraktu
FROM         Wykonawcy 
             INNER JOIN Imprezy 
             ON Wykonawcy.IDWykonawcy = Imprezy.IDWykonawcy
ORDER BY Wykonawcy.NazwaScenicznaWykonawcy;
GO

CREATE VIEW R13_wynagrodzenie_czlonkow_zespolu
AS
SELECT TOP (100) PERCENT Wykonawcy.IDWykonawcy, Czlonkowie.ImieCzlonka, Czlonkowie.NazwiskoCzlonka, 
                      CAST(SUM(Imprezy.WartoscKontraktu) /
                          (SELECT     COUNT(*)
                            FROM          Czlonkowie_zespolu AS EM2
                            WHERE      EM2.Status <> 3 AND EM2.IDWykonawcy = Wykonawcy.IDWykonawcy) AS Money) AS WynagrCzlZes
FROM         Czlonkowie 
INNER JOIN   Czlonkowie_zespolu 
ON Czlonkowie.IDCzlonka = Czlonkowie_zespolu.IDCzlonka 
INNER JOIN   Wykonawcy 
ON Wykonawcy.IDWykonawcy = Czlonkowie_zespolu.IDWykonawcy 
INNER JOIN   Imprezy 
ON Wykonawcy.IDWykonawcy = Imprezy.IDWykonawcy
WHERE     (Czlonkowie_zespolu.Status <> 3)
GROUP BY Wykonawcy.IDWykonawcy, Czlonkowie.ImieCzlonka, Czlonkowie.NazwiskoCzlonka
ORDER BY Czlonkowie.NazwiskoCzlonka;
GO

CREATE VIEW R14_kontrakty_agentow_duze_prowizje
AS
SELECT Agenci.ImieAgenta, Agenci.NazwiskoAgenta, sum(Imprezy.WartoscKontraktu) AS SumaWartosciKontraktow, convert(money,sum(WartoscKontraktu) * Premia) AS Prowizja
FROM Agenci 
INNER JOIN Imprezy 
ON (Agenci.IDAgenta = Imprezy.IDAgenta)
GROUP BY Agenci.ImieAgenta, Agenci.NazwiskoAgenta, Agenci.Premia
HAVING sum(WartoscKontraktu * Premia) > 1000 ;
GO

CREATE VIEW R14_agenci_z_umowami_za_ponad_3000_w_12_2017
AS
SELECT Agenci.ImieAgenta, Agenci.NazwiskoAgenta, Sum(Imprezy.WartoscKontraktu) AS LacznaWartKontr
FROM Agenci 
INNER JOIN Imprezy 
ON (Agenci.IDAgenta = Imprezy.IDAgenta)
WHERE Imprezy.DzienRozpoczecia Between '12/1/2017' And '12/31/2017'
GROUP BY Agenci.ImieAgenta, Agenci.NazwiskoAgenta
HAVING sum(Imprezy.WartoscKontraktu) > 3000 ;
GO

CREATE VIEW R14_wykonawcy_z_ponad_2_rownoleglymi_wystepami
AS
SELECT     IDWykonawcy, NazwaScenicznaWykonawcy
FROM         Wykonawcy
WHERE     (IDWykonawcy IN
             (SELECT     E1.IDWykonawcy
              FROM          Imprezy AS E1 
              INNER JOIN Imprezy AS E2 
              ON E1.IDWykonawcy = E2.IDWykonawcy
              WHERE      E1.NumerImprezy <> E2.NumerImprezy                AND E1.DzienRozpoczecia <= E2.DzienZakonczenia 
               AND E1.DzienZakonczenia >= E2.DzienRozpoczecia
              GROUP BY E1.IDWykonawcy
              HAVING      COUNT(*) > 2));
GO

CREATE VIEW R14_zespoly_jazzowe_liczace_wiecej_niz_3_czlonkow
AS 
SELECT Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy, Count(Czlonkowie_zespolu.IDWykonawcy) AS LiczbaCzlonkow
FROM ((Wykonawcy INNER JOIN Czlonkowie_zespolu 
ON Wykonawcy.IDWykonawcy=Czlonkowie_zespolu.IDWykonawcy) 
INNER JOIN Style_wykonawcow 
ON Wykonawcy.IDWykonawcy=Style_wykonawcow.IDWykonawcy) 
INNER JOIN Style_muzyczne 
ON Style_muzyczne.IDStylu=Style_wykonawcow.IDStylu
WHERE Style_muzyczne.NazwaStylu='Jazz'
GROUP BY Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
HAVING Count(Czlonkowie_zespolu.IDWykonawcy)>3;
GO

CREATE VIEW R18_agenci_bez_kontraktow_na_country_countryrock
AS 
SELECT Agenci.IDAgenta, Agenci.ImieAgenta, Agenci.NazwiskoAgenta
FROM Agenci
WHERE Agenci.IDAgenta NOT IN 
(SELECT Imprezy.IDAgenta 
FROM ((Imprezy
INNER JOIN Wykonawcy 
ON Imprezy.IDWykonawcy = Wykonawcy.IDWykonawcy) 
INNER JOIN Style_wykonawcow 
ON Wykonawcy.IDWykonawcy = Style_wykonawcow.IDWykonawcy) 
INNER JOIN Style_muzyczne 
ON Style_wykonawcow.IDStylu = Style_muzyczne.IDStylu
WHERE Style_muzyczne.NazwaStylu IN ('Country', 'Country Rock'));
GO

CREATE VIEW R18_klienci_bez_rezerwacji_NOT_IN
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM Klienci
WHERE Klienci.IDKlienta NOT IN
(SELECT Imprezy.IDKlienta FROM Imprezy);
GO

CREATE VIEW R18_klienci_ktorzy_nie_rezerwowali_wystepu_Topazz_i_MD
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM Klienci
WHERE Klienci.IDKlienta NOT IN
(SELECT IDKlienta 
FROM Imprezy
INNER JOIN Wykonawcy 
ON Imprezy.IDWykonawcy = Wykonawcy.IDWykonawcy 
WHERE Wykonawcy.NazwaScenicznaWykonawcy = 'Topazz')
AND IDKlienta NOT IN
(SELECT IDKlienta 
FROM Imprezy
INNER JOIN Wykonawcy 
ON Imprezy.IDWykonawcy = Wykonawcy.IDWykonawcy 
WHERE Wykonawcy.NazwaScenicznaWykonawcy = 'Modern Dance');
GO

CREATE VIEW R18_klienci_Peacock_Coie_Jazz_EXISTS
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM Klienci
WHERE EXISTS  
(SELECT Imprezy.IDKlienta 
FROM Imprezy
INNER JOIN Wykonawcy 
ON Imprezy.IDWykonawcy=Wykonawcy.IDWykonawcy 
WHERE Wykonawcy.NazwaScenicznaWykonawcy='Carol Peacock Trio'
AND Imprezy.IDKlienta = Klienci.IDKlienta)
AND EXISTS 
(SELECT Imprezy.IDKlienta 
FROM Imprezy
INNER JOIN Wykonawcy 
ON Imprezy.IDWykonawcy=Wykonawcy.IDWykonawcy 
WHERE Wykonawcy.NazwaScenicznaWykonawcy='Caroline Coie Cuartet'
AND Imprezy.IDKlienta = Klienci.IDKlienta)
AND EXISTS 
(SELECT Imprezy.IDKlienta 
FROM Imprezy
INNER JOIN Wykonawcy 
ON Imprezy.IDWykonawcy=Wykonawcy.IDWykonawcy 
WHERE Wykonawcy.NazwaScenicznaWykonawcy='Jazz Persuasion'
AND Imprezy.IDKlienta = Klienci.IDKlienta);
GO

CREATE VIEW R18_klienci_Peacock_Coie_Jazz_IN_DOBRZE
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM Klienci
WHERE Klienci.IDKlienta IN 
(SELECT Imprezy.IDKlienta 
FROM Imprezy
INNER JOIN Wykonawcy 
ON Imprezy.IDWykonawcy=Wykonawcy.IDWykonawcy 
WHERE Wykonawcy.NazwaScenicznaWykonawcy='Carol Peacock Trio')
AND Klienci.IDKlienta IN 
(SELECT Imprezy.IDKlienta 
FROM Imprezy
INNER JOIN Wykonawcy 
ON Imprezy.IDWykonawcy=Wykonawcy.IDWykonawcy 
WHERE Wykonawcy.NazwaScenicznaWykonawcy='Caroline Coie Cuartet')
AND Klienci.IDKlienta IN 
(SELECT Imprezy.IDKlienta 
FROM Imprezy
INNER JOIN Wykonawcy 
ON Imprezy.IDWykonawcy=Wykonawcy.IDWykonawcy 
WHERE Wykonawcy.NazwaScenicznaWykonawcy='Jazz Persuasion');
GO

CREATE VIEW R18_klienci_Peacock_Coie_Jazz_IN_ZLE
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta
FROM Klienci
WHERE Klienci.IDKlienta IN 
(SELECT Klienci.IDKlienta 
FROM (Klienci
INNER JOIN Imprezy 
ON Klienci.IDKlienta = Imprezy.IDKlienta) 
INNER JOIN Wykonawcy 
ON Imprezy.IDWykonawcy = Wykonawcy.IDWykonawcy  
WHERE Wykonawcy.NazwaScenicznaWykonawcy IN 
('Carol Peacock Trio', 'Caroline Coie Cuartet', 'Jazz Persuasion'));
GO

CREATE VIEW R18_klienci_Peacock_Coie_Jazz_INNERJOIN
AS 
SELECT DISTINCT CPT.IDKlienta, CPT.ImieKlienta, CPT.NazwiskoKlienta
FROM ((SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta FROM (Klienci
INNER JOIN Imprezy
ON Klienci.IDKlienta=Imprezy.IDKlienta)
INNER JOIN Wykonawcy
ON Imprezy.IDWykonawcy=Wykonawcy.IDWykonawcy WHERE Wykonawcy.NazwaScenicznaWykonawcy='Carol Peacock Trio')  AS CPT
INNER JOIN (SELECT Klienci.IDKlienta FROM (Klienci
INNER JOIN Imprezy
ON Klienci.IDKlienta=Imprezy.IDKlienta)
INNER JOIN Wykonawcy
ON Imprezy.IDWykonawcy=Wykonawcy.IDWykonawcy WHERE Wykonawcy.NazwaScenicznaWykonawcy='Caroline Coie Cuartet')  AS CCC
ON CPT.IDKlienta=CCC.IDKlienta)
INNER JOIN (SELECT Klienci.IDKlienta FROM (Klienci
INNER JOIN Imprezy
ON Klienci.IDKlienta=Imprezy.IDKlienta)
INNER JOIN Wykonawcy
ON Imprezy.IDWykonawcy=Wykonawcy.IDWykonawcy WHERE Wykonawcy.NazwaScenicznaWykonawcy='Jazz Persuasion')  AS JP
ON CCC.IDKlienta=JP.IDKlienta;
GO

CREATE VIEW R18_wykonawcy_wystepujacy_dla_Berga_I_Hallmark_EXISTS
AS 
SELECT Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
FROM Wykonawcy
WHERE EXISTS 
(SELECT * FROM Klienci 
INNER JOIN Imprezy 
ON Klienci.IDKlienta = Imprezy.IDKlienta 
WHERE Klienci.NazwiskoKlienta='Berg'
AND Imprezy.IDWykonawcy = Wykonawcy.IDWykonawcy) 
AND EXISTS 
(SELECT * 
FROM Klienci 
INNER JOIN Imprezy 
ON Klienci.IDKlienta = Imprezy.IDKlienta 
WHERE Klienci.NazwiskoKlienta='Hallmark'
AND Imprezy.IDWykonawcy = Wykonawcy.IDWykonawcy);
GO

CREATE VIEW R18_wykonawcy_doskonale_pasujacy_do_gustu_klienta
AS 
SELECT Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy, Count(Gusty_muzyczne.IDStylu) AS LiczbaStylow
FROM ((Klienci
INNER JOIN Gusty_muzyczne
ON Klienci.IDKlienta=Gusty_muzyczne.IDKlienta)
INNER JOIN Style_wykonawcow
ON Gusty_muzyczne.IDStylu=Style_wykonawcow.IDStylu)
INNER JOIN Wykonawcy
ON Wykonawcy.IDWykonawcy=Style_wykonawcow.IDWykonawcy
GROUP BY Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
HAVING Count(Gusty_muzyczne.IDStylu) =  (SELECT Count(*)  FROM Gusty_muzyczne  WHERE Gusty_muzyczne.IDKlienta = Klienci.IDKlienta);
GO

CREATE VIEW R18_wyk_dla_klientow_Hartwig_McCrae_i_Rosales_EXISTS
AS 
SELECT Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
FROM Wykonawcy
WHERE EXISTS 
(SELECT * FROM Klienci 
INNER JOIN Imprezy 
ON Klienci.IDKlienta = Imprezy.IDKlienta 
WHERE Klienci.NazwiskoKlienta='Hartwig'
AND Imprezy.IDWykonawcy = Wykonawcy.IDWykonawcy) 
AND EXISTS 
(SELECT * 
FROM Klienci 
INNER JOIN Imprezy 
ON Klienci.IDKlienta = Imprezy.IDKlienta 
WHERE Klienci.NazwiskoKlienta='McCrae'
AND Imprezy.IDWykonawcy = Wykonawcy.IDWykonawcy)
AND EXISTS 
(SELECT * 
FROM Klienci 
INNER JOIN Imprezy 
ON Klienci.IDKlienta = Imprezy.IDKlienta 
WHERE Klienci.NazwiskoKlienta='Rosales'
AND Imprezy.IDWykonawcy = Wykonawcy.IDWykonawcy);
GO

CREATE VIEW R18_wykonawcy_jazz_rhythmblues_salsa_HAVING
AS 
SELECT Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
FROM (Wykonawcy
INNER JOIN Style_wykonawcow
ON Wykonawcy.IDWykonawcy=Style_wykonawcow.IDWykonawcy)
INNER JOIN Style_muzyczne
ON Style_wykonawcow.IDStylu=Style_muzyczne.IDStylu
WHERE Style_muzyczne.NazwaStylu In ('Jazz','Rhythm and Blues','Salsa')
GROUP BY Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
HAVING Count(*)=3;
GO

CREATE VIEW R18_wykonawcy_jazz_rhythmblues_salsa_IN
AS 
SELECT Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
FROM Wykonawcy
WHERE Wykonawcy.IDWykonawcy IN 
(SELECT Style_wykonawcow.IDWykonawcy 
FROM Style_wykonawcow
INNER JOIN Style_muzyczne
ON Style_wykonawcow.IDStylu = Style_muzyczne.IDStylu
WHERE Style_muzyczne.NazwaStylu = 'Jazz')
AND Wykonawcy.IDWykonawcy IN  
(SELECT Style_wykonawcow.IDWykonawcy 
FROM Style_wykonawcow
INNER JOIN Style_muzyczne
ON Style_wykonawcow.IDStylu = Style_muzyczne.IDStylu
WHERE Style_muzyczne.NazwaStylu = 'Rhythm and Blues')
AND Wykonawcy.IDWykonawcy IN
(SELECT Style_wykonawcow.IDWykonawcy 
FROM Style_wykonawcow
INNER JOIN Style_muzyczne
ON Style_wykonawcow.IDStylu = Style_muzyczne.IDStylu
WHERE Style_muzyczne.NazwaStylu = 'Salsa');
GO

CREATE VIEW R18_wykonawcy_jazz_rhythmblues_salsa_IN_ZLE
AS 
SELECT Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
FROM Wykonawcy
WHERE Wykonawcy.IDWykonawcy IN 
(SELECT Style_wykonawcow.IDWykonawcy 
FROM Style_wykonawcow
INNER JOIN Style_muzyczne
ON Style_wykonawcow.IDStylu = Style_muzyczne.IDStylu
WHERE Style_muzyczne.NazwaStylu IN ('Jazz', 'Rhythm and Blues', 'Salsa'));
GO

CREATE VIEW R18_wykonawcy_nigdy_nie_zamawiani_NOT_IN
AS 
SELECT Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
FROM Wykonawcy
WHERE Wykonawcy.IDWykonawcy NOT IN
(SELECT Imprezy.IDWykonawcy FROM Imprezy);
GO

CREATE VIEW R18_wykonawcy_nie_wystepujacy_90_dni_przed_1maja2018
AS 
SELECT Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy
FROM Wykonawcy
WHERE Wykonawcy.IDWykonawcy NOT IN
(SELECT Imprezy.IDWykonawcy 
FROM Imprezy 
WHERE Imprezy.DzienRozpoczecia >DateAdd(d, -90, '2018-05-01'));
GO

CREATE VIEW R19_gusty_klientow_i_oldies
AS
SELECT        Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta, 
                         (CASE NazwaStylu 
                          WHEN 'Muzyka lat 50.' THEN 'Oldies' 
                          WHEN 'Muzyka lat 60.' THEN 'Oldies' 
                          WHEN 'Muzyka lat 70.' THEN 'Oldies' 
                          WHEN 'Muzyka lat 80.' THEN 'Oldies' ELSE NazwaStylu
                          END) AS StylKlienta
FROM            Klienci INNER JOIN Gusty_muzyczne 
                          ON Klienci.IDKlienta = Gusty_muzyczne.IDKlienta 
                          INNER JOIN Style_muzyczne 
                          ON Gusty_muzyczne.IDStylu = Style_muzyczne.IDStylu;
GO

CREATE VIEW R19_klienci_lubiacy_jazz_ale_nie_standardy
AS
SELECT        IDKlienta, ImieKlienta, NazwiskoKlienta
FROM            Klienci
WHERE        (1 = (CASE WHEN IDKlienta NOT IN
                             (SELECT        IDKlienta
                               FROM            Gusty_muzyczne INNER JOIN Style_muzyczne 
                                               ON Gusty_muzyczne.IDStylu = Style_muzyczne.IDStylu
                               WHERE        Style_muzyczne.NazwaStylu = 'Jazz') 
                   THEN 0 
                   WHEN IDKlienta IN
                             (SELECT        IDKlienta
                               FROM            Gusty_muzyczne INNER JOIN Style_muzyczne 
                                               ON Gusty_muzyczne.IDStylu = Style_muzyczne.IDStylu
                               WHERE        Style_muzyczne.NazwaStylu = 'Standardy') 
                   THEN 0 ELSE 1 END));
GO

CREATE VIEW R19_wykonawcy_wystepujacy_na_gwiazdke_2017
AS
SELECT        IDWykonawcy, NazwaScenicznaWykonawcy, 
              (CASE WHEN IDWykonawcy IN
                             (SELECT        IDWykonawcy
                               FROM            Imprezy
                               WHERE        CAST('2017-12-25' AS Date) BETWEEN DzienRozpoczecia AND DzienZakonczenia) 
                    THEN 'Zarezerwowany' ELSE 'Bez rezerwacji' END) AS RezerwSwieta2017
FROM            Wykonawcy;
GO

CREATE VIEW R19_wykonawcy_grajacy_jazz_ale_nie_wspolczesna
AS
SELECT        IDWykonawcy, NazwaScenicznaWykonawcy
FROM            Wykonawcy
WHERE        (1 = (CASE WHEN IDWykonawcy NOT IN
                             (SELECT        IDWykonawcy
                               FROM            Style_wykonawcow INNER JOIN
                                                         Style_muzyczne ON Style_wykonawcow.IDStylu = Style_muzyczne.IDStylu
                               WHERE        Style_muzyczne.NazwaStylu = 'Jazz') 
                   THEN 0 
                   WHEN IDWykonawcy IN
                             (SELECT        IDWykonawcy
                               FROM            Style_wykonawcow INNER JOIN
                                                         Style_muzyczne ON Style_wykonawcow.IDStylu = Style_muzyczne.IDStylu
                               WHERE        Style_muzyczne.NazwaStylu = 'Współczesna') 
                   THEN 0 ELSE 1 END));
GO

CREATE VIEW R20_agenci_wykonawcy_bez_rezerwacji_1lut2018
AS
SELECT TOP (100) PERCENT Agenci.IDAgenta, Agenci.ImieAgenta, Agenci.NazwiskoAgenta, Agenci.AdresAgenta, Agenci.MiastoAgenta, Agenci.StanZamAgenta, Agenci.KodPocztowyAgenta, 
            Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy, Wykonawcy.TelefonWykonawcy, Style_muzyczne.NazwaStylu
FROM Agenci, (Wykonawcy INNER JOIN Style_wykonawcow 
                          ON Wykonawcy.IDWykonawcy = Style_wykonawcow.IDWykonawcy) 
                         INNER JOIN Style_muzyczne 
                         ON Style_muzyczne.IDStylu = Style_wykonawcow.IDStylu
WHERE Wykonawcy.IDWykonawcy Not In 
    (SELECT Imprezy.IDWykonawcy 
     FROM Imprezy 
     WHERE Imprezy.DzienZakonczenia >= CAST('2018-02-01' AS date)
          AND Imprezy.DzienRozpoczecia <= CAST('2018-02-01' AS date))
ORDER BY Agenci.IDAgenta, Wykonawcy.IDWykonawcy;
GO

CREATE VIEW R20_wszystkie_dni_grudnia_i_wystepy
AS 
SELECT ztblDni.PoleDaty, BD.IDWykonawcy, BD.NazwaScenicznaWykonawcy
FROM ztblDni LEFT JOIN 
(SELECT ztblDni.PoleDaty, Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy 
FROM ztblDni, Wykonawcy INNER JOIN Imprezy
ON Wykonawcy.IDWykonawcy=Imprezy.IDWykonawcy 
WHERE ztblDni.PoleDaty>=Imprezy.DzienRozpoczecia 
AND ztblDni.PoleDaty<=Imprezy.DzienZakonczenia 
AND ztblDni.PoleDaty Between CAST('2017-12-01' AS date) AND CAST('2017-12-31' AS date))  AS BD
ON ztblDni.PoleDaty=BD.PoleDaty
WHERE ztblDni.PoleDaty Between CAST('2017-12-01' AS date) And CAST('2017-12-31' AS date);
GO


CREATE VIEW R20_wszystkie_imprezy_sty2018_podzial_na_tygodnie
AS 
SELECT ztblTygodnie.PoczatekTygodnia, ztblTygodnie.KoniecTygodnia, Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy, 
  Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Imprezy.DzienRozpoczecia, Imprezy.DzienZakonczenia
FROM ztblTygodnie, (Klienci INNER JOIN Imprezy
ON Klienci.IDKlienta=Imprezy.IDKlienta)
INNER JOIN Wykonawcy
ON Wykonawcy.IDWykonawcy=Imprezy.IDWykonawcy
WHERE (ztblTygodnie.PoczatekTygodnia <= CAST('2018-01-31' AS date))
AND (ztblTygodnie.KoniecTygodnia >= CAST('2018-01-01' AS date))
AND (Imprezy.DzienRozpoczecia <= ztblTygodnie.KoniecTygodnia)
AND (Imprezy.DzienZakonczenia >= ztblTygodnie.PoczatekTygodnia);
GO


CREATE VIEW R20_etykiety_do_wysylki_z_pominieciem_4
AS 
SELECT TOP 100 PERCENT * FROM 
(SELECT ' ' As ImieKlienta, ' ' As NazwiskoKlienta, ' ' As AdresKlienta, ' ' As MiastoKlienta, ' ' As StanZamKlienta, ' ' As KodPocztowyKlienta 
FROM ztblPomijanieEtykiet
WHERE ztblPomijanieEtykiet.LicznikEtykiet <= 4
UNION ALL SELECT Klienci.ImieKlienta, Klienci.NazwiskoKlienta, Klienci.AdresKlienta, Klienci.MiastoKlienta, Klienci.StanZamKlienta, Klienci.KodPocztowyKlienta
FROM Klienci) AS CustLabels 
ORDER BY KodPocztowyKlienta, NazwiskoKlienta;
GO


CREATE VIEW R20_ranking_gustow_muzycznych_klientow
AS 
SELECT TOP 100 PERCENT Style_muzyczne.IDStylu, Style_muzyczne.NazwaStylu, COUNT(RankingGustow.PierwszyStyl) AS PierwszaPreferencja, 
  COUNT(RankingGustow.DrugiStyl) AS DrugaPreferencja, COUNT(RankingGustow.TrzeciStyl) AS TrzeciaPreferencja
FROM Style_muzyczne, (SELECT (CASE WHEN Gusty_muzyczne.KolejnoscPreferencji = 1 
                              THEN Gusty_muzyczne.IDStylu ELSE Null END) As PierwszyStyl, 
                              (CASE WHEN Gusty_muzyczne.KolejnoscPreferencji = 2
                              THEN Gusty_muzyczne.IDStylu ELSE Null END) As DrugiStyl, 
                              (CASE WHEN Gusty_muzyczne.KolejnoscPreferencji = 3 
                              THEN Gusty_muzyczne.IDStylu ELSE Null END) As TrzeciStyl
			FROM Gusty_muzyczne)  AS RankingGustow
WHERE Style_muzyczne.IDStylu = RankingGustow.PierwszyStyl 
OR Style_muzyczne.IDStylu = RankingGustow.DrugiStyl
OR Style_muzyczne.IDStylu = RankingGustow.TrzeciStyl
GROUP BY IDStylu, NazwaStylu
HAVING COUNT(PierwszyStyl) > 0 
OR     COUNT(DrugiStyl) > 0 
OR     COUNT(TrzeciStyl) > 0
ORDER BY PierwszaPreferencja DESC, DrugaPreferencja DESC, TrzeciaPreferencja DESC, IDStylu;
GO


CREATE VIEW R20_klienci_o_gustach_pasujacych_do_stylow_wykonawcow
AS 
SELECT IDKlienta, ImieKlienta, NazwiskoKlienta, IDWykonawcy, NazwaScenicznaWykonawcy, 
   PierwszaPreferencja, DrugaPreferencja, TrzeciaPreferencja, PierwszyWplyw, DrugiWplyw, TrzeciWplyw
FROM (SELECT 		Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta, 
		MAX((CASE WHEN Gusty_muzyczne.KolejnoscPreferencji = 1  
                     THEN Gusty_muzyczne.IDStylu ELSE Null END)) AS PierwszaPreferencja,
		MAX((CASE WHEN Gusty_muzyczne.KolejnoscPreferencji = 2  
                     THEN Gusty_muzyczne.IDStylu ELSE Null END)) AS DrugaPreferencja,
		MAX((CASE WHEN Gusty_muzyczne.KolejnoscPreferencji = 3  
                     THEN Gusty_muzyczne.IDStylu ELSE Null END)) AS TrzeciaPreferencja
	FROM Gusty_muzyczne
        INNER JOIN Klienci
        ON Gusty_muzyczne.IDKlienta = Klienci.IDKlienta 
GROUP BY Klienci.IDKlienta, Klienci.ImieKlienta, Klienci.NazwiskoKlienta)  AS RankingGustow, 
(SELECT Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy, 
		MAX((CASE WHEN Style_wykonawcow.WplywStylu = 1 
                     THEN Style_wykonawcow.IDStylu ELSE Null END)) AS PierwszyWplyw, 
		MAX((CASE WHEN Style_wykonawcow.WplywStylu = 2 
                     THEN Style_wykonawcow.IDStylu ELSE Null END)) AS DrugiWplyw, 
		MAX((CASE WHEN Style_wykonawcow.WplywStylu = 3 
                     THEN Style_wykonawcow.IDStylu ELSE Null END)) As TrzeciWplyw 
	FROM Style_wykonawcow
        INNER JOIN Wykonawcy 
        ON Style_wykonawcow.IDWykonawcy = Wykonawcy.IDWykonawcy 
GROUP BY Wykonawcy.IDWykonawcy, Wykonawcy.NazwaScenicznaWykonawcy)  AS RankedStrengths
WHERE ((PierwszaPreferencja = PierwszyWplyw)
AND (DrugaPreferencja = DrugiWplyw))
OR ((DrugaPreferencja =PierwszyWplyw)
AND (PierwszaPreferencja = DrugiWplyw));
GO


CREATE VIEW R20_laczne_kwoty_rezerwacji_wg_miesiaca
AS 
SELECT Wykonawcy.NazwaScenicznaWykonawcy, SUM(Imprezy.WartoscKontraktu*ztblMiesiace.Styczen) AS Styczen, 
   SUM(Imprezy.WartoscKontraktu*ztblMiesiace.Luty) AS Luty, 
   SUM(Imprezy.WartoscKontraktu*ztblMiesiace.Marzec) AS Marzec, 
   SUM(Imprezy.WartoscKontraktu*ztblMiesiace.Kwiecien) AS Kwiecien, 
   SUM(Imprezy.WartoscKontraktu*ztblMiesiace.Maj) AS Maj, 
   SUM(Imprezy.WartoscKontraktu*ztblMiesiace.Czerwiec) AS Czerwiec, 
   SUM(Imprezy.WartoscKontraktu*ztblMiesiace.Lipiec) AS Lipiec, 
   SUM(Imprezy.WartoscKontraktu*ztblMiesiace.Sierpien) AS Sierpien, 
   SUM(Imprezy.WartoscKontraktu*ztblMiesiace.Wrzesien) AS Wrzesien, 
   SUM(Imprezy.WartoscKontraktu*ztblMiesiace.Pazdziernik) AS Pazdziernik, 
   SUM(Imprezy.WartoscKontraktu*ztblMiesiace.Listopad) AS Listopad, 
   SUM(Imprezy.WartoscKontraktu*ztblMiesiace.Grudzien) AS Grudzien
FROM ztblMiesiace, Wykonawcy
INNER JOIN Imprezy
ON Wykonawcy.IDWykonawcy=Imprezy.IDWykonawcy
WHERE Imprezy.DzienRozpoczecia BETWEEN ztblMiesiace.PoczatekMiesiaca
AND ztblMiesiace.KoniecMiesiaca
GROUP BY Wykonawcy.NazwaScenicznaWykonawcy;
GO


CREATE VIEW R20_ranking_wplywu_stylow_wykonawcow
AS 
SELECT TOP 100 PERCENT Style_muzyczne.IDStylu, Style_muzyczne.NazwaStylu, COUNT(RankingGustow.PierwszyStyl) AS PierwszyWplyw, 
   COUNT(RankingGustow.DrugiStyl) AS DrugiWplyw, COUNT(RankingGustow.TrzeciStyl) AS TrzeciWplyw
FROM Style_muzyczne, 
(SELECT (CASE WHEN Style_wykonawcow.WplywStylu = 1 
              THEN Style_wykonawcow.IDStylu ELSE Null END) As PierwszyStyl, 
        (CASE WHEN Style_wykonawcow.WplywStylu = 2 
              THEN Style_wykonawcow.IDStylu ELSE Null END) As DrugiStyl, 
        (CASE WHEN Style_wykonawcow.WplywStylu = 3 
              THEN Style_wykonawcow.IDStylu ELSE Null END) As TrzeciStyl
FROM Style_wykonawcow)  AS RankingGustow
WHERE Style_muzyczne.IDStylu = RankingGustow.PierwszyStyl
OR Style_muzyczne.IDStylu = RankingGustow.DrugiStyl
OR Style_muzyczne.IDStylu = RankingGustow.TrzeciStyl
GROUP BY IDStylu, NazwaStylu
HAVING COUNT(PierwszyStyl) > 0 
OR     COUNT(DrugiStyl) > 0 
OR     COUNT(TrzeciStyl) > 0
ORDER BY PierwszyWplyw DESC, DrugiWplyw DESC, TrzeciWplyw DESC, IDStylu;
GO


CREATE VIEW R21_miastoagenta_miastoklienta_sumy_oplat_GROUPING_SETS
AS
SELECT A.MiastoAgenta, C.MiastoKlienta, Count(*) AS NumImprezy, Sum(E.WartoscKontraktu) AS Oplata
FROM Imprezy AS E
  INNER JOIN Klienci AS C
    ON C.IDKlienta = E.IDKlienta 
  INNER JOIN Agenci AS A
    ON A.IDAgenta = E.IDAgenta 
GROUP BY GROUPING SETS (A.MiastoAgenta, C.MiastoKlienta, (A.MiastoAgenta, C.MiastoKlienta));
GO

CREATE VIEW R21_miastoklienta_styl_GROUPING_SETS
AS
SELECT MiastoKlienta, NazwaStylu, Count(*) AS Liczba
FROM Klienci
  INNER JOIN Gusty_muzyczne  
    ON Gusty_muzyczne.IDKlienta = Klienci.IDKlienta
  INNER JOIN Style_muzyczne
    ON Style_muzyczne.IDStylu = Gusty_muzyczne.IDStylu
GROUP BY GROUPING SETS (MiastoKlienta, NazwaStylu, (MiastoKlienta, NazwaStylu));
GO

CREATE VIEW R21_miastowykonawcy_styl_ROLLUP
AS
SELECT MiastoWykonawcy, NazwaStylu, Count(*) AS Liczba
FROM Wykonawcy
  INNER JOIN Style_wykonawcow 
    ON Style_wykonawcow.IDWykonawcy = Wykonawcy.IDWykonawcy
  INNER JOIN Style_muzyczne
    ON Style_muzyczne.IDStylu = Style_wykonawcow.IDStylu
GROUP BY ROLLUP (MiastoWykonawcy, NazwaStylu);
GO

CREATE VIEW R21_styl_kodpocztowyklienta_zliczanie_GROUPING_SETS
AS
SELECT MS.NazwaStylu, C.KodPocztowyKlienta, Count(*) AS Wystapienia
FROM Klienci AS C
  INNER JOIN Gusty_muzyczne AS MP
    ON MP.IDKlienta = C.IDKlienta
  INNER JOIN Style_muzyczne AS MS
    ON MS.IDStylu = MP.IDStylu
GROUP BY GROUPING SETS (MS.NazwaStylu, C.KodPocztowyKlienta);
GO

CREATE VIEW R22_ranking_agentow
AS
SELECT Agenci.IDAgenta,
  Agenci.ImieAgenta + ' ' + Agenci.NazwiskoAgenta AS Agent,
  COUNT(Imprezy.NumerImprezy) AS Wystepy,
  RANK() OVER (
    ORDER BY COUNT(Imprezy.NumerImprezy) DESC
  ) AS PozycjaWRankingu
FROM Agenci
  LEFT JOIN Imprezy 
    ON Imprezy.IDAgenta = Agenci.IDAgenta
GROUP BY Agenci.IDAgenta, Agenci.ImieAgenta, Agenci.NazwiskoAgenta;
GO

CREATE VIEW R22_klienci_wgmiast_sumy_gustow
AS
SELECT C.MiastoKlienta, 
  C.ImieKlienta + ' ' + C.NazwiskoKlienta AS Klient, 
  COUNT(*) AS Gusty,
  SUM(COUNT(*)) OVER (
    ORDER BY C.MiastoKlienta
      ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW
  ) AS SumaZWierszy,
  SUM(COUNT(*)) OVER (
    ORDER BY C.MiastoKlienta
    RANGE BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW
  ) AS SumaZZakresow
FROM Klienci AS C
  INNER JOIN Gusty_muzyczne AS MP
    ON MP.IDKlienta = C.IDKlienta
GROUP BY C.MiastoKlienta, C.ImieKlienta, C.NazwiskoKlienta;
GO

CREATE VIEW R22_klienci_preferowanestyle_liczba
AS
SELECT C.IDKlienta, 
  C.ImieKlienta + ' ' + C.NazwiskoKlienta AS Klient, 
  Count(*) AS Gusty
FROM Klienci AS C
  INNER JOIN Gusty_muzyczne AS MP
    ON MP.IDKlienta = C.IDKlienta
GROUP BY C.IDKlienta, C.ImieKlienta, C.NazwiskoKlienta;
GO

CREATE VIEW R22_klienci_preferowanestyle_szczegoly_wiele_zliczen
AS
SELECT C.IDKlienta, 
  C.ImieKlienta + ' ' + C.NazwiskoKlienta AS Klient, 
  MS.NazwaStylu, 
  Count(*) OVER (
    PARTITION BY C.IDKlienta
	ORDER BY C.IDKlienta
  ) AS GustyKlienta,
  Count(*) OVER (
	ORDER BY C.IDKlienta
  ) AS GustySuma
FROM Klienci AS C
  INNER JOIN Gusty_muzyczne AS MP
    ON MP.IDKlienta = C.IDKlienta
  INNER JOIN Style_muzyczne AS MS
    ON MS.IDStylu = MP.IDStylu;
GO

CREATE VIEW R22_klienci_preferowanestyle_szczegoly_liczba
AS
SELECT C.IDKlienta, 
  C.ImieKlienta + ' ' + C.NazwiskoKlienta AS Klient, 
  MS.NazwaStylu, 
  COUNT(*) OVER (
    PARTITION BY C.IDKlienta
  ) AS Gusty
FROM Klienci AS C
  INNER JOIN Gusty_muzyczne AS MP
    ON MP.IDKlienta = C.IDKlienta
  INNER JOIN Style_muzyczne AS MS
    ON MS.IDStylu = MP.IDStylu;
GO

CREATE VIEW R22_klienci_preferowanestyle_szczegoly_wiele_zliczen_kol1
AS
SELECT C.IDKlienta,
  C.ImieKlienta + ' ' + C.NazwiskoKlienta AS Klient, 
  MS.NazwaStylu, 
  Count(*) OVER (
    PARTITION BY C.IDKlienta
	ORDER BY C.NazwiskoKlienta, C.ImieKlienta
  ) AS GustyKlienta,
  Count(*) OVER (
	ORDER BY C.NazwiskoKlienta, C.ImieKlienta
  ) AS GustySuma
FROM Klienci AS C
  INNER JOIN Gusty_muzyczne AS MP
    ON MP.IDKlienta = C.IDKlienta
  INNER JOIN Style_muzyczne AS MS
    ON MS.IDStylu = MP.IDStylu;
GO

CREATE VIEW R22_klienci_preferowanestyle_szczegoly_wiele_zliczen_kol2 
AS
SELECT C.IDKlienta,
  C.ImieKlienta + ' ' + C.NazwiskoKlienta AS Klient, 
  MS.NazwaStylu, 
  Count(*) OVER (
    PARTITION BY C.IDKlienta
	ORDER BY MS.NazwaStylu
  ) AS GustyKlienta,
  Count(*) OVER (
	ORDER BY MS.NazwaStylu
  ) AS GustySuma
FROM Klienci AS C
  INNER JOIN Gusty_muzyczne AS MP
    ON MP.IDKlienta = C.IDKlienta
  INNER JOIN Style_muzyczne AS MS
    ON MS.IDStylu = MP.IDStylu;
GO

CREATE VIEW R22_klienci_preferowanestyle_szczegoly_NO_PARTITION 
AS
SELECT C.IDKlienta, 
  C.ImieKlienta + ' ' + C.NazwiskoKlienta AS Klient, 
  MS.NazwaStylu, 
  Count(*) OVER (
	ORDER BY C.IDKlienta
  ) AS Gusty
FROM Klienci AS C
  INNER JOIN Gusty_muzyczne AS MP
    ON MP.IDKlienta = C.IDKlienta
  INNER JOIN Style_muzyczne AS MS
    ON MS.IDStylu = MP.IDStylu;
GO

CREATE VIEW R22_numerowanie_imprez
AS
SELECT ROW_NUMBER() OVER (
	ORDER BY Imprezy.DzienRozpoczecia
  ) AS Liczba,
  Imprezy.DzienRozpoczecia,
  ROW_NUMBER() OVER (
    PARTITION BY Imprezy.DzienRozpoczecia
	ORDER BY Imprezy.DzienRozpoczecia
  ) AS NumerWgDaty,
  Klienci.ImieKlienta + ' ' + Klienci.NazwiskoKlienta AS Klient,
  Wykonawcy.NazwaScenicznaWykonawcy AS Wykonawca
FROM Imprezy 
  INNER JOIN Wykonawcy
    ON Wykonawcy.IDWykonawcy = Imprezy.IDWykonawcy
  INNER JOIN Klienci
    ON Klienci.IDKlienta = Imprezy.IDKlienta;
GO

CREATE VIEW R22_wykonawcy_w_3_grupach
AS
SELECT Wykonawcy.NazwaScenicznaWykonawcy AS Wykonawca, 
  COUNT(Imprezy.IDWykonawcy) AS Wystepy,
  NTILE(3) OVER (
    ORDER BY COUNT(Imprezy.IDWykonawcy) DESC
  ) AS [Group]
FROM Wykonawcy 
  LEFT JOIN Imprezy 
    ON Imprezy.IDWykonawcy = Wykonawcy.IDWykonawcy
GROUP BY Wykonawcy.NazwaScenicznaWykonawcy;
GO

CREATE VIEW R22_wykonawcy_i_ich_imprezy
AS
SELECT Wykonawcy.NazwaScenicznaWykonawcy,
  Klienci.ImieKlienta + ' ' + Klienci.NazwiskoKlienta AS Klient,
  Imprezy.DzienRozpoczecia, 
  COUNT(Imprezy.NumerImprezy) OVER (
    PARTITION BY Wykonawcy.IDWykonawcy
  ) AS Wystepy
FROM Wykonawcy
  LEFT JOIN Imprezy 
    ON Imprezy.IDWykonawcy = Wykonawcy.IDWykonawcy
  INNER JOIN Klienci   
    ON Klienci.IDKlienta = Imprezy.IDKlienta;
GO

CREATE VIEW R22_lista_wykonawcow 
AS
SELECT Wykonawcy.NazwaScenicznaWykonawcy,
  ROW_NUMBER() OVER (
    PARTITION BY Wykonawcy.NazwaScenicznaWykonawcy
    ORDER BY Czlonkowie.NazwiskoCzlonka, Czlonkowie.ImieCzlonka
  ) AS NumerCzlonka,
  Czlonkowie.ImieCzlonka + ' ' + Czlonkowie.NazwiskoCzlonka AS Czlonek
FROM Wykonawcy
  INNER JOIN Czlonkowie_zespolu 
    ON Czlonkowie_zespolu.IDWykonawcy = Wykonawcy.IDWykonawcy
  INNER JOIN Czlonkowie 
    ON Czlonkowie.IDCzlonka = Czlonkowie_zespolu.IDCzlonka;
GO

CREATE VIEW R22_nieparzyste_sumy_kontraktow
AS
SELECT C.ImieKlienta + ' ' +  C.NazwiskoKlienta AS Klient,
  E.DzienRozpoczecia, E.WartoscKontraktu,
  SUM(E.WartoscKontraktu) OVER (
    ORDER BY C.NazwiskoKlienta, C.ImieKlienta
    ROWS BETWEEN 1 PRECEDING AND 1 FOLLOWING
  ) AS SumaTrzech, 
  SUM(E.WartoscKontraktu) OVER (
    PARTITION BY C.NazwiskoKlienta, C.ImieKlienta
    ORDER BY C.NazwiskoKlienta, C.ImieKlienta
    ROWS BETWEEN 1 PRECEDING AND 1 FOLLOWING
  ) AS PodzSumaTrzech 
FROM Imprezy AS E
  INNER JOIN Klienci AS C
    ON C.IDKlienta = E.IDKlienta;
GO
